IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_CPL_MEDIAF_FACE_ESPECIAL]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PROD_CPL_MEDIAF_FACE_ESPECIAL]
GO 

GO
CREATE FUNCTION [dbo].[UFD_EST_PROD_CPL_MEDIAF_FACE_ESPECIAL] (	@CD_EMP				INT,
																@CD_FILIAL			NVARCHAR(MAX),
																@CD_LINHA			NVARCHAR(MAX),
																@CD_CATEG			NVARCHAR(MAX),
																@CD_AREA			NVARCHAR(MAX))

RETURNS @TBL_RETORNO TABLE (	CD_ARV_MERC_CATEG	INT,
								DS_ARV_MERC_CATEG	VARCHAR(200),
								QT_EST				MONEY,
								QTDE_FACEAMENTO		MONEY,
								MEDIAF				MONEY,
								COB_LJ				MONEY,
								EXCESSO				MONEY,
								EXCESSO_DIA				MONEY,
								QTDE_FACE_DIA		MONEY,
								QT_EST_CD			MONEY,
								MEDIAF_CD			MONEY,
								COB_CD 				MONEY,
								ITENS				MONEY)

AS
BEGIN 

/************************************************************************************************************************************************/

DECLARE @DEPOSITO AS TABLE (	CD_EMP				INT,
								CD_ARV_MERC_CATEG	INT,
								QT_EST_CD			MONEY,          
								MEDIAF_CD			MONEY,          
								COB_CD				MONEY
								PRIMARY KEY (CD_ARV_MERC_CATEG,  CD_EMP))
/************************************************************************************************************************************************/

DECLARE @CATEGORIAS TABLE (	CD_EMP				INT,
							DS_ARV_MERC_CATEG	VARCHAR (100),	
							CD_ARV_MERC_CATEG	INT,
							CD_ARV_MERC_DEPTO INT)
INSERT INTO @CATEGORIAS
SELECT DISTINCT
	CD_EMP, DS_ARV_MERC_CATEG, CD_ARV_MERC_CATEG ,CD_ARV_MERC_DEPTO
FROM
	EST_ARV_MERC_CATEGORIA
WHERE
	CD_ARV_MERC_CATEG  IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_CATEG));

/************************************************************************************************************************************************/
DECLARE @FILIAL TABLE (	CD_EMP		INT,
						CD_FILIAL	INT)

INSERT INTO @FILIAL
SELECT DISTINCT
	CD_EMP, CD_FILIAL
FROM
	PRC_FILIAL 
WHERE
	CD_FILIAL = (SELECT CD_FILIAL FROM PRC_FILIAL WHERE CD_EMP=1 AND FILIAL_MTZ=1 );


/************************************************************************************************************************************************/
DECLARE @LINHAS TABLE (	CD_EMP				INT,
								CD_ARV_MERC_LINHA	INT)
INSERT INTO @LINHAS
SELECT DISTINCT
	CD_EMP, CD_ARV_MERC_LINHA 
FROM
	EST_ARV_MERC_LINHA
WHERE
	CD_ARV_MERC_LINHA IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_LINHA))

/************************************************************************************************************************************************/
DECLARE @DEPTO TABLE (	CD_EMP				INT,
						CD_ARV_MERC_DEPTO	INT)
INSERT INTO @DEPTO
SELECT DISTINCT
	CD_EMP, 
	CD_ARV_MERC_DEPTO
FROM
	EST_ARV_MERC_DEPTO
WHERE
	CD_ARV_MERC_AREA_ATEND  IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_AREA))

/************************************************************************************************************************************************/
 
/************************************************************************************************************************************************/
 
DECLARE @QT_IT AS TABLE (	CD_EMP      INT,
							CD_ARV_MERC_CATEG  INT,     
							ITENS		MONEY
							PRIMARY KEY (CD_ARV_MERC_CATEG, CD_EMP))

/************************************************************************************************************************************************/


DECLARE @LOJAS AS TABLE (	CD_EMP				INT,
							CD_ARV_MERC_CATEG	INT,
							DS_ARV_MERC_CATEG	VARCHAR(200),
							QT_EST				MONEY,
							QTDE_FACEAMENTO		MONEY,
							MEDIAF				MONEY,
							EMAX_QTDE			MONEY 
							PRIMARY KEY (CD_ARV_MERC_CATEG,   CD_EMP))

/************************************************************************************************************************************************/

		INSERT INTO @DEPOSITO
		SELECT 
			P.CD_EMP, 
			C.CD_ARV_MERC_CATEG, 
			SUM(P.QT_EST + P.QT_EST_EM_TERC)  QT_EST, 
			SUM(P.MEDIAF)  MEDIAF_CD,
			SUM(CASE WHEN P.MEDIAF > 0 THEN  
				((P.QT_EST + P.QT_EST_EM_TERC)/P.MEDIAF)  * 30 
				ELSE  0 END)  COB_CD
		FROM 
			EST_PROD_CPL P
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON
			P.CD_EMP=A.CD_EMP AND
			P.CD_PROD=A.CD_PROD
			
			
			INNER JOIN @FILIAL F ON
			P.CD_EMP	= F.CD_EMP AND
			P.CD_FILIAL = F.CD_FILIAL

			INNER JOIN @LINHAS L ON
			A.CD_EMP			= L.CD_EMP AND
			A.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA


			INNER JOIN @CATEGORIAS C ON
			A.CD_EMP			= C.CD_EMP AND
			A.CD_ARV_MERC_CATEG = C.CD_ARV_MERC_CATEG

			INNER JOIN @DEPTO D ON 
			C.CD_EMP			=D.CD_EMP AND
			C.CD_ARV_MERC_DEPTO	=D.CD_ARV_MERC_DEPTO

		WHERE 
			P.CD_EMP=@CD_EMP  
		GROUP BY 	
			P.CD_EMP, 
			C.CD_ARV_MERC_CATEG


/************************************************************************************************************************************************/

		INSERT INTO @LOJAS
		SELECT 
			P.CD_EMP, 
			A.CD_ARV_MERC_CATEG, 
			C.DS_ARV_MERC_CATEG, 
			SUM(P.QT_EST + P.QT_EST_EM_TERC)  QT_EST, 
			SUM(P.QTDE_FACEAMENTO) QTDE_FACEAMENTO,
			SUM(P.MEDIAF)  MEDIAF,
			SUM((P.MEDIAF/30.) * P.EMAX ) EMAX_QTDE 

		FROM 
			EST_PROD_CPL P
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON
			P.CD_EMP=A.CD_EMP AND
			P.CD_PROD=A.CD_PROD
			
			INNER JOIN @FILIAL F ON
			P.CD_EMP	= F.CD_EMP AND
			P.CD_FILIAL = F.CD_FILIAL

			INNER JOIN @LINHAS L ON
			A.CD_EMP			= L.CD_EMP AND
			A.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA


			INNER JOIN @CATEGORIAS C ON
			A.CD_EMP			= C.CD_EMP AND
			A.CD_ARV_MERC_CATEG = C.CD_ARV_MERC_CATEG

			INNER JOIN @DEPTO D ON 
			C.CD_EMP			=D.CD_EMP AND
			C.CD_ARV_MERC_DEPTO	=D.CD_ARV_MERC_DEPTO

		WHERE 
			P.CD_EMP=1  
			AND P.STS_PROD=0
		GROUP BY 	
			P.CD_EMP, 
			A.CD_ARV_MERC_CATEG,
			C.DS_ARV_MERC_CATEG  

/************************************************************************************************************************************************/

		INSERT INTO @QT_IT
		SELECT 
			A.CD_EMP, 
			A.CD_ARV_MERC_CATEG, 
			COUNT (A.CD_PROD) ITENS 
		FROM 
			EST_PROD_EST_ARV_MERCADOLOGICA A

			INNER JOIN @LINHAS L ON
			A.CD_EMP			= L.CD_EMP AND
			A.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA


			INNER JOIN @CATEGORIAS C ON
			A.CD_EMP			= C.CD_EMP AND
			A.CD_ARV_MERC_CATEG = C.CD_ARV_MERC_CATEG

			INNER JOIN @DEPTO D ON 
			C.CD_EMP			=D.CD_EMP AND
			C.CD_ARV_MERC_DEPTO	=D.CD_ARV_MERC_DEPTO 
		WHERE 
			A.CD_EMP= @CD_EMP 
		GROUP BY  
			A.CD_EMP, 
			A.CD_ARV_MERC_CATEG

/************************************************************************************************************************************************/
					
/************************************************************************************************************************************************/
		INSERT INTO @TBL_RETORNO
		SELECT 

			L.CD_ARV_MERC_CATEG,
			L.DS_ARV_MERC_CATEG,
			SUM( L.QT_EST) QT_EST,
			SUM( L.QTDE_FACEAMENTO)  QTDE_FACEAMENTO,
			SUM( L.MEDIAF) MEDIAF ,
			
			CASE WHEN  SUM( L.MEDIAF) > 0 THEN
				SUM(L.QT_EST)/ SUM( L.MEDIAF) * 30
			ELSE 0 END  COB_LJ ,

			CASE WHEN SUM(EMAX_QTDE) <  SUM( L.QT_EST) THEN
				   (SUM( L.QT_EST) - SUM(EMAX_QTDE))
			ELSE 0 END   EXCESSO ,

			(CASE WHEN SUM(EMAX_QTDE) <  SUM( L.QT_EST) THEN
					CASE WHEN 	SUM(L.MEDIAF) > 0 THEN
						(SUM( L.QT_EST) - SUM(EMAX_QTDE)) /SUM(L.MEDIAF) * 30
					ELSE
						0
					END 

			ELSE 0 END ) EXCESSO_DIA,

			CASE WHEN  SUM( L.MEDIAF) > 0 THEN
				SUM(L.QTDE_FACEAMENTO)/ SUM( L.MEDIAF) * 30
			ELSE 0 END  QTDE_FACE_DIA ,
		 

			SUM( D.QT_EST_CD) QT_EST_CD ,
			SUM( D.MEDIAF_CD) MEDIAF_CD,
			
			CASE WHEN  SUM( D.MEDIAF_CD) > 0 THEN
				SUM(D.QT_EST_CD)/ SUM(D.MEDIAF_CD) * 30
			ELSE 0 END  COB_CD ,

			Q.ITENS

		FROM 
			@LOJAS L
			
			INNER JOIN @DEPOSITO D ON
			L.CD_EMP = D.CD_EMP AND
			L.CD_ARV_MERC_CATEG = D.CD_ARV_MERC_CATEG

			INNER JOIN @QT_IT Q ON
			L.CD_EMP=Q.CD_EMP AND
			L.CD_ARV_MERC_CATEG  =Q.CD_ARV_MERC_CATEG	

		WHERE
			L.CD_EMP=@CD_EMP 
			
		GROUP BY
			L.CD_ARV_MERC_CATEG,
			L.DS_ARV_MERC_CATEG,
			Q.ITENS



RETURN

END

